/**
 * Практическое занятие №5. "Старые" потоковые функции стандартной библиотеки.
 * Указатели на функции. Структуры.
 */

#include <iostream>
//#include <cstdio>
#include "other.h"


int main()
{
    /**
     * Задание 1. "Старые" потоковые функции стандартной библиотеки.
     *
     * Эти функции использовались в языке C. Если вы будете писать программы на
     * нем, вам придется использовать их вместо std::cin и std::cout.
     */

    /**
     * Задание 1.1.
     *
     * С помощью функции scanf сформирйуте три коэффициента: A,B,C.
     */

    /**
     * Задание 1.2.
     *
     * Выведите (красиво!) таблицу значений y=A*x*x + B*x + C при изменении x в
     * диапазоне -2 до +2 с шагом 0.5
     */

    /**
     * Задание 2. Указатели на функции.
     */

    /**
     * Задание 2.1. Указатель на функцию. "Калькулятор".
     *
     * Напишите функции:
     * 1. add - принимает два значения double и возвращает сумму этих значений;
     * 2. sub- принимает два значения double и возвращает разность этих
     *    значений;
     * 3. mul - аналогично для умножения;
     * 4. div - аналогично для деления;
     * 5. а для возведения в степень можете использовать функцию стандартной
     *    библиотеки - pow(). 
     *
     * Подсказка 1: прототип функции находится в <cmath>.
     * Подсказка 2: стандартная библиотека предоставляет несколько
     * перегруженных вариантов этой функции, а Вам потребуется сформировать
     * указатель на double pow(double, double).
     *
     * Предоставьте пользователю следующую возможность:
     *
     * - пока пользователь хочет пользоваться услугами вашего калькулятора, он
     *   может вводить два значения и знак операции а вы выводите результат. 
     * - результат получаете посредством вызова соответствующей вашей функции
     *   по указателю.
     * - предусмотрите возможность ввода непредусмотренного знака операции.
     */

    /**
     * Задание 2.2. Указатель на функцию в качестве аргумента.
     *
     * Дана заготовка функции сортировки любых объектов - sort.
     *
     * Функция принимает следующие параметры:
     * 1. указатель на первый сортируемый элемент
     * 2. количество сортируемых элементов
     * 3. размер элемента в байтах
     * 4. указатель на функцию перестановки элементов
     * 5. указатель на функцию сравнения элементов
     */

    /**
     * Задание 2.2.1.
     *
     * Напишите функцию перестановки двух целых значений - swap_int, которая
     * принимает два void указателя и меняет значения местами.
     *
     * Напишите функцию сравнения двух целых значений - CmpInt, которая
     * принимает два void указателя и возвращает int результат сравнения:  
     * <0 - первый элемент меньше, чем второй;
     * =0 - равны;
     * >0 - первый элемент больше, чем второй.
     *
     * Используйте эти функции в функции сортировки.
     */
    {
        // int nAr[]=...   //массив для сортировки
        // int nTotal=...          //количество элементов в массиве 

        /** Печать исходного массива */

        // sort(reinterpret_cast<char*>(&nAr[0]), nTotal, sizeof(int), 
        //      SwapInt, CmpInt);

        /** Печать результатов сортировки */
    }

    /**
     * Задание 2.2.2.
     *
     * По аналогии с заданием 2.2.1 напишите функцию swap_double и cmp_double,
     * и вызовите функцию sort для сортировки вещественных значений.
     */

    /**
     * Задание 2.2.3.
     *
     * По аналогии с 2.2.1 создайте вспомогательные функции - swap_str и
     * cmp_str и вызовите функцию sort для сортировки массива указателей на
     * строки.
     */

    {
        const char* arStr[] = {"QQQ", "SDF", "ABC"};
    }

    /**
     * Задание 2.3. Массивы указателей на функцию.
     *
     * Напишите функции для работы с массивом:
     *
     * 1. print_max - печатает максимальный элемент;
     * 2. print_min - печатает минимальный элемент;
     * 3. sort_asc - сортирует по возрастанию и выводит на печать;
     * 4. sort_desc - сортирует по убыванию и выводит на печать.
     *
     * У всех эти функций должна быть одинаковая сигнатура. Объявите, два
     * массива: массив указателей на функции 1-4 и массив указателей на строки
     * с описанием этих функций.
     *
     * Реализуйте меню для пользователя: выведите нумерованный список имен
     * функций (из второго массива), примите от пользователя номер функции,
     * после чего вызовите функцию для какого-нибудь массива.
     */

    /**
     * Задание 2.4. Метод прямоугольников.
     *
     * Напишите функцию integrate, которая бы принимала:
     * 1. указатель на интегрируемую функцию, которая принимает double и
     *    возвращает double;
     * 2. нижнюю границу интегрирования (вещественное число);
     * 3. верхнюю границу интегрирования (вещественное число);
     * 4. количество отрезков, на которых будет вычисляться функция.
     *
     * Функция должна возвращать численное значение определенного интеграла,
     * полученного методом прямоугольников.
     *
     * Проверьте функцию на разных вещественных функциях (линейных, параболах,
     * exp, sin) и сравните полученные результаты с теоретическими.
     */

    /**
     * Задание 3. Структуры С.
     */

    /**
     * Задание 3.1. Структура Book.
     */

    /**
     * Задание 3.1.1.
     *
     * Объявите структуру Book, описывающую книгу (автор, заглавие, год
     * издания, цена, категория…).
     *
     * Подумайте: какого типа могут быть поля структуры.
     * Подсказка: объявление структуры рекомендуется выносить в заголовочный
     * файл.
     */

    /**
     * Задание 3.1.2.
     *
     * Создайте разными способами (глобальный, локальный, статический,
     * динамический) экземпляры (объекты) типа Book (без инициализации).
     *
     * Определите - сколько памяти отводит компилятор под каждый такой объект. 
     *
     * Как инициализируются (или не инициализируются) поля структуры?
     *
     * Подумайте: от чего зависит объем выделяемой памяти?
     */

    /**
     * Задание 3.1.3. 
     *
     * Заполните поля созданных объектов.
     *
     * Замечание: если для хранения строки используется массив, необходимо
     * предусмотреть "защиту" от выхода за границы массива.
     */

    /**
     * Задание 3.1.4. 
     *
     * Напишите функцию, выводящую на экран реквизиты книги.
     *
     * Подумайте: как эффективнее передавать экземпляр Book в функцию.
     *
     * Для вывода на консоль используйте функцию стандартной библиотеки printf.
     */

    /**
     * Задание 3.1.5.
     *
     * Напишите функцию для формирования полей структуры. Для ввода используйте
     * функцию стандартной библиотеки scanf.
     *
     * Замечание: неплохо заложить в такую функцию возможность проверки
     * корректности введенного значения, например, год издания не может быть
     * меьше, чем... (год появления письменности), категорию ползователь должен
     * выбирать из существующих, цена не может быть отрицательной...
     *
     * Кроме этого необходимо проверить и ошибки другого рода: программа
     * ожидает число, а пользователь ввел случайно букву.
     */

    /**
     * Задание 3.2. Матричные операции.
     */

    /**
     * Задание 3.2.1. 
     *
     * Задайте структуру Matrix, которая будет преставлять вещественную матрицу
     * размера MxN из линейной алгебры.
     *
     * Это определение и связанные с ними функции определите в отдельной паре
     * файлов: matrix.h и matrix.cpp.
     */

    /**
     * Задание 3.2.2.
     *
     * Создайте набор базовых функций для работы с этой структурой:
     *
     * - void m_zero(Matrix *A, int m, int n) - инициализация матрицы размера m
     *   на n нулями;
     * - void m_id(Matrix *A, int n) - инициализация единичной матрицы n на n;
     * - void m_free(Matrix *A) - очистка памяти, используемой для матрицы;
     * - void m_copy(const Matrix *src, Matrix *dst) - копирование данных
     *   матрицы src в матрицу dst.
     * - int m_width(const Matrix *A) - ширина матрицы A;
     * - int m_height(const Matrix *A) - высота матрицы A;
     * - double m_get(const Matrix* A, int i, int j) - получение i,j-того
     *   элемента матрицы;
     * - void m_set(Matrix *A, int i, int j, double value) - установка i,j-того
     *   элемента матрицы.
     */

    /**
     * Задание 3.2.3.
     *
     * Реализуйте набор операций из линейной алгебры:
     *
     * - int m_add(Matrix *A, const Matrix *B) - если A и B одинакового
     *   размера, то прибавляет к A значения B и возвращает 0; иначе возвращает
     *   1.
     * - void m_neg(Matrix *A) - заменяет все элементы матрицы A на
     *   противоположные.
     * - int m_mult(const Matrix *A, const Matrix *B, Matrix *dst) - умножает
     *   матрицу A на матрицу B и сохраняет результат в dst. Если размеры
     *   матрицы не позволяют умножить матрицы, функция возвращает 1, иначе 0.
     */

    /**
     * Задание 3.2.4.
     *
     * С помощью полученного функционала реализуйте матричное вычисление чисел
     * Фибоначчи. Делается это с помощью такой формулы:
     *
     * /  F[n]  \ = / 1  1 \ * / F[n-1] \
     * \ F[n-1] /   \ 1  0 /   \ F[n-2] /
     *
     * Задайте матрицу в центре и матрицу-вектор с двумя первыми числами
     * Фибоначчи: 1 и 0. Выполняйте эту формулу итеративно и выведите первые 40
     * чисел Фибоначчи.
     */

    return 0;
}
