/**
 * Практическое занятие №6. Консольное приложение.
 *
 * Темы:
 * - динамический массив структур,
 * - добавление, чтение, изменение и удаление структур,
 * - поиск,
 * - сортировка,
 * - сохранение данных в файл и чтение данных из файла,
 * - обработка ошибок пользовательского ввода,
 * - работа с функциями семейства printf и scanf,
 * - функциональная и модульная декомпозиция программы.
 *
 * Отдельные задания в этой работе не нужно выполнять последовательно, в этой
 * работе задания скорее являются требованиями к тому, что ваша программа должна
 * делать.
 *
 * Обратите внимание на следующие указания.
 *
 * 1. Для ввода и вывода данных из консоли и файлов *необходимо* использовать
 *    фукцнии семейства printf и scanf.
 * 2. Ваша программа должна быть оформлена в виде нескольких файлов исходного
 *    кода, каждый из которых реализует набор функций, относящихся к одной теме.
 * 3. В результате работы программы не должно быть утечек памяти.
 * 4. Для каждой функциональности приложения у пользователя должен быть консольный 
 *    интерфейс (см. ниже). Этот интерфейс должен быть устойчив к человеческим ошибкам
 *    (например, если пользователь выбрал несуществующий пункт меню или ввел букву 
 *    вместо числа).
 * 5. Вам необходимо выполнить индивидуальное задание, которое закодировано на странице
 *    http://13633.mooo.com/file/att.html. Напротив вашей фамилии указан тип сортировки,
 *    который вам нужно реализовать и дополнительное задание по номеру:
 *    1) вывести все книги данного автора и/или данного жанра, автор и жанр вводится 
 *       пользователем;
 *    2) найти книгу с самым маленьким годом издания после заданного пользователем года;
 *    3) найти наиболее популярный жанр книг среди книг картотеки;
 *    4) найти минимальный, максимальный, средний (арифметически) и средний в смысле 
 *       медианы год издания книги среди книг в картотеке;
 *    5) найти книги с самым длинным и самым коротким названием.
 * 
 * Консольный интерфейс главного меню может выглядеть примерно так:
 *
 * ```
   Добро пожаловать в библиотеку! Выберите действие:
   1. Распечатать библиотеку.
   2. Добавить книгу.
   ...
   0. Выход из программы.
  
   Ваше действие: _
 * ```
 */

int main() {

    /**
     * Задание 1. Создание «картотеки» книг.
     * «Картотека» — это динамический массив структур.
     * Реализуйте структуру, которая хранит информацию о книгах:
     * название, автор, год издания, жанр, краткое описание.
     *
     * Важно! Массив должен быть динамическим, то есть его размер
     * будет увеличиваться по мере добавления книг. Для этого
     * нужно использовать динамическое выделение памяти с
     * последующим расширением массива по мере необходимости.
     * Старайтесь не выделять память слишком часто,
     * чтобы не ухудшить производительность, используйте стратегию
     * "перераспределения" с увеличением массива на определенный коэффициент
     * (например, на 1.5x).
     *
     * Пользователь должен иметь возможность выполнять следующие действия:
     * 
     * 1. Распечатать содержимое картотеки.
     * 2. Добавить новую книгу.
     * 3. Удалить книгу по названию.
     * 4. Изменить информацию о книге (например, изменить описание).
     * 5. Сохранить текущее содержимое картотеки в файл.
     * 6. Загрузить содержимое картотеки из файла.
     * 7. Действие по вашему варианту.
     * 8. Выйти из программы.
     */

    /**
     * Задание 2. Печать картотеки.
     *
     * Реализуйте печать картотеки на экран по запросу пользователя.
     */

    /**
     * Задание 3. Добавление новой книги.
     *
     * Реализуйте для пользователя возможность добавлять новые книги с заполнением полей
     * книги в интерактивном режиме.
     *
     * При этом необходимо обработать некорректный пользовательский ввод.
     */

    /**
     * Задание 4. Сортировка книг.
     *
     * Реализуйте возможность сортировать картотеку по одному из полей по выбору
     * пользователя. Учтите сортировку по возрастанию и убыванию.
     *
     * Учтите, что сортировка должна быть стабильное, то есть менять порядок
     * книг с одинаковыми значениями критерия.
     *
     * Алгоритм сортировки должен быть выбран согласно вашему варианту.
     *
     * Задание со * (опционально): реализуйте сортировку по нескольким полям.
     */

    /**
     * Задание 5. Поиск книг.
     *
     * Реализуйте поиск книг по одному из критериев:
     * - по названию книги,
     * - по автору,
     * - по жанру.
     */

    /**
     * Задание 6. Удаление книги.
     *
     * Реализуйте удаление книги из картотеки. При этом следите, чтобы память
     * освобождалась корректно и, когда книг останется меньше, чем выделено памяти,
     * перевыделите память.
     *
     * Задание со * (опционально): реализуйте "отмену" последних k-операций.
     */

    /**
     * Задание 7. Изменение книги.
     *
     * Реализуйте изменение полей уже добавленной книги. При этом так же, как и при 
     * добавлении книги, обработайте ошибки.
     */

    /**
     * Задание 8. Запись в файл и чтение из файла.
     *
     * Реализуйте сохранение картотеки в файл и чтение из него. При этом сделайте 
     * возможность пользователю выбрать файл для чтения и записи.
     *
     * Обработайте ошибки связанные с выбором несуществующего файла или файла с 
     * неверным форматом.
     */

    return 0;
}
